<?php $title='New Rep Order'; ob_start(); ?>
<h1>Create Order (Rep)</h1>
<form method="post" action="<?= app_url('rep/orders/create') ?>" class="card">
  <label>Customer</label>
  <select name="customer_id" required>
    <option value="">-- Select --</option>
    <?php foreach($customers as $c): ?>
      <option value="<?= (int)$c['id'] ?>"><?= htmlspecialchars(($c['first_name'] ?? '').' '.($c['last_name'] ?? '').' — '.($c['email'] ?? '')) ?></option>
    <?php endforeach; ?>
  </select>

  <label>PO Number (optional)</label>
  <input name="po_number" placeholder="Customer PO">

  <h3>Lines</h3>
  <div id="lines">
    <div class="grid grid-2 line">
      <div>
        <label>Product</label>
        <select name="product_id[]">
          <?php foreach($products as $p): ?>
            <option value="<?= (int)$p['id'] ?>"><?= htmlspecialchars($p['sku'].' — '.$p['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Qty</label>
        <input type="number" name="qty[]" value="1" min="1">
      </div>
    </div>
  </div>
  <div class="actions">
    <button type="button" class="btn" onclick="addLine()">Add Line</button>
    <button class="btn btn-primary">Create Order</button>
  </div>
</form>

<script>
function addLine(){
  const container = document.getElementById('lines');
  const first = container.querySelector('.line');
  const clone = first.cloneNode(true);
  clone.querySelector('input[name="qty[]"]').value = 1;
  container.appendChild(clone);
}
</script>
<?php $content=ob_get_clean(); include __DIR__ . '/../../layouts/base.php'; ?>
