<?php $title='Orders'; ob_start(); ?>
<h1>Orders</h1>
<table class="table">
  <tr>
    <th>#</th><th>Order #</th><th>Status</th><th>Type</th>
    <th>User</th><th>Customer</th><th>Company</th>
    <th>Grand Total</th><th>Placed</th><th>Actions</th>
  </tr>
  <?php foreach($orders as $o): ?>
  <tr>
    <td><?= (int)$o['id'] ?></td>
    <td><?= htmlspecialchars($o['order_number']) ?></td>
    <td><?= htmlspecialchars($o['status']) ?></td>
    <td><?= htmlspecialchars($o['type']) ?></td>
    <td><?= htmlspecialchars($o['user_email'] ?? '') ?></td>
    <td><?= htmlspecialchars(trim(($o['first_name'] ?? '').' '.($o['last_name'] ?? ''))) ?></td>
    <td><?= htmlspecialchars($o['company_name'] ?? '') ?></td>
    <td>$<?= number_format((float)$o['grand_total'],2) ?></td>
    <td><?= htmlspecialchars($o['placed_at']) ?></td>
    <td><a class="btn" href="<?= app_url('admin/orders/show?id='.(int)$o['id']) ?>">View</a></td>
  </tr>
  <?php endforeach; ?>
</table>
<?php $content=ob_get_clean(); include __DIR__ . '/../../layouts/base.php'; ?>
