<?php
namespace App\Models;
use App\Core\DB;

class OrderAdmin {
    public static function listOrders(int $limit = 200): array {
        $sql = "SELECT o.*, u.email AS user_email, c.name AS company_name, cu.first_name, cu.last_name
                  FROM orders o
             LEFT JOIN users u      ON u.id = o.user_id
             LEFT JOIN companies c  ON c.id = o.company_id
             LEFT JOIN customers cu ON cu.id = o.customer_id
              ORDER BY o.placed_at DESC
                 LIMIT ?";
        $st = DB::$pdo->prepare($sql);
        $st->bindValue(1, $limit, \PDO::PARAM_INT);
        $st->execute();
        return $st->fetchAll();
    }

    public static function find(int $id): ?array {
        $st = DB::$pdo->prepare("SELECT * FROM orders WHERE id=?");
        $st->execute([$id]);
        $o = $st->fetch();
        if (!$o) return null;

        $it = DB::$pdo->prepare("SELECT * FROM order_items WHERE order_id=? ORDER BY id");
        $it->execute([$id]);
        $o['items'] = $it->fetchAll();
        return $o;
    }

    public static function updateStatus(int $id, string $status): void {
        $allowed = ['draft','pending','paid','fulfilled','cancelled'];
        if (!in_array($status, $allowed, true)) { return; }
        $st = DB::$pdo->prepare("UPDATE orders SET status=?, updated_at=NOW() WHERE id=?");
        $st->execute([$status, $id]);
    }
}
