<?php
namespace App\Controllers\Rep;
use App\Models\RepModel;
use App\Models\Catalog;
use App\Models\Pricing;
use App\Models\OrderModel;
use App\Core\Auth;

class OrdersController {
    public function __construct(private array $config){}

    public function createForm(){
        $rep_user_id = Auth::user()['id'] ?? 0;
        $customers = RepModel::myCustomers((int)$rep_user_id);
        $products = Catalog::listProducts();
        include __DIR__ . '/../../Views/rep/orders/create.php';
    }

    public function create($req,$res){
        $rep_user_id = Auth::user()['id'] ?? null;
        $customer_id = (int)($_POST['customer_id'] ?? 0);
        if ($customer_id <= 0) { $_SESSION['error'] = 'Select a customer'; return $res->redirect('/rep/orders/new'); }

        $items = [];
        $subtotal = 0.0;
        $pids = $_POST['product_id'] ?? [];
        $qtys = $_POST['qty'] ?? [];
        foreach ($pids as $idx => $pid) {
            $pid = (int)$pid;
            $qty = max(0, (int)($qtys[$idx] ?? 0));
            if ($pid <= 0 || $qty <= 0) continue;
            $p = Catalog::findProduct($pid);
            if (!$p) continue;
            $price = Pricing::priceFor($pid, $qty);
            $items[] = [
                'product_id' => $pid,
                'sku' => $p['sku'],
                'name' => $p['name'],
                'qty' => $qty,
                'uom' => $p['uom'] ?? 'ea',
                'price' => $price,
                'discount' => 0,
                'tax' => 0,
            ];
            $subtotal += $price * $qty;
        }
        if (!$items) { $_SESSION['error'] = 'Add at least one line'; return $res->redirect('/rep/orders/new'); }

        $data = [
            'user_id' => $rep_user_id,
            'customer_id' => $customer_id,
            'company_id' => null,
            'rep_id' => null,
            'type' => 'rep',
            'status' => 'pending',
            'subtotal' => $subtotal,
            'discount_total' => 0,
            'tax_total' => 0,
            'shipping_total' => 0,
            'grand_total' => $subtotal,
            'currency' => 'USD',
            'po_number' => $_POST['po_number'] ?? null,
        ];

        $order_id = OrderModel::createOrder($data, $items);
        $_SESSION['flash'] = 'Rep order created: #'.$order_id;
        return $res->redirect('/rep');
    }
}
