<?php
namespace App\Controllers\Admin;
use App\Models\OrderAdmin;

class OrdersController {
    public function __construct(private array $config){}

    public function index(){
        $orders = OrderAdmin::listOrders();
        include __DIR__ . '/../../Views/admin/orders/index.php';
    }

    public function show(){
        $id = (int)($_GET['id'] ?? 0);
        $order = \App\Models\OrderAdmin::find($id);
        if (!$order) { http_response_code(404); echo 'Order not found'; return; }
        include __DIR__ . '/../../Views/admin/orders/show.php';
    }

    public function updateStatus($req,$res){
        $id = (int)($_POST['id'] ?? 0);
        $status = (string)($_POST['status'] ?? '');
        if ($id > 0) {
            \App\Models\OrderAdmin::updateStatus($id, $status);
            $_SESSION['flash'] = 'Order status updated';
        }
        return $res->redirect('/admin/orders/show?id='.$id);
    }
}
