<?php
namespace App\Controllers;
use App\Models\Catalog;
use App\Models\Pricing;

class CartController {
    public function __construct(private array $config){}

    private function cartLines(): array {
        $lines = [];
        $cart = $_SESSION['cart'] ?? [];
        foreach ($cart as $pid => $qty) {
            $p = \App\Models\Catalog::findProduct((int)$pid);
            if (!$p) continue;
            $price = \App\Models\Pricing::priceFor((int)$pid, (int)$qty);
            $lines[] = [
                'product_id' => (int)$pid,
                'sku' => $p['sku'],
                'name' => $p['name'],
                'uom' => $p['uom'] ?? 'ea',
                'qty' => (int)$qty,
                'price' => (float)$price,
                'subtotal' => (float)$price * (int)$qty,
            ];
        }
        return $lines;
    }

    public function view(){
        $lines = $this->cartLines();
        $subtotal = array_sum(array_column($lines, 'subtotal'));
        include __DIR__ . '/../Views/cart/view.php';
    }

    public function update($req,$res){
        $qtys = $_POST['qty'] ?? [];
        $new = [];
        foreach ($qtys as $pid => $q) {
            $q = (int)$q;
            if ($q > 0) $new[(int)$pid] = $q;
        }
        $_SESSION['cart'] = $new;
        return $res->redirect('/cart');
    }

    public function clear($req,$res){
        unset($_SESSION['cart']);
        return $res->redirect('/cart');
    }
}
