<?php
namespace App\Models;
use App\Core\DB;

class Pricing {
    public static function priceFor(int $product_id, int $qty = 1): float {
        $sql = "SELECT pli.price
                  FROM price_lists pl
                  JOIN price_list_items pli ON pli.price_list_id = pl.id
                 WHERE pl.is_default = 1 AND pli.product_id = ? AND pli.min_qty <= ?
              ORDER BY pli.min_qty DESC LIMIT 1";
        $st = DB::$pdo->prepare($sql);
        $st->execute([$product_id, $qty]);
        $row = $st->fetch();
        if ($row && isset($row['price'])) {
            return (float)$row['price'];
        }
        $st = DB::$pdo->prepare("SELECT base_price FROM products WHERE id = ?");
        $st->execute([$product_id]);
        $p = $st->fetch();
        return (float)($p['base_price'] ?? 0.0);
    }
}
