<?php
namespace App\Models;
use App\Core\DB;

class Catalog {
    public static function listProducts(): array {
        $sql = "SELECT p.*, (
                   SELECT GROUP_CONCAT(c.name ORDER BY c.name SEPARATOR ', ')
                     FROM product_categories pc
                     LEFT JOIN categories c ON c.id = pc.category_id
                    WHERE pc.product_id = p.id
                 ) AS categories
                FROM products p
                WHERE p.status = 'active'
                ORDER BY p.name";
        return DB::$pdo->query($sql)->fetchAll();
    }
    public static function findProduct(int $id) {
        $st = DB::$pdo->prepare("SELECT * FROM products WHERE id=?");
        $st->execute([$id]);
        return $st->fetch();
    }
}
