<?php
namespace App\Controllers;
use App\Models\Catalog;
use App\Models\Pricing;
use App\Models\OrderModel;
use App\Core\Auth;

class CheckoutController {
    public function __construct(private array $config){}

    public function form(){
        $cart = $_SESSION['cart'] ?? [];
        if (!$cart) { $_SESSION['error'] = 'Your cart is empty.'; header('Location: '.$this->config['app']['base_url'].'/shop'); return; }
        include __DIR__ . '/../Views/checkout/form.php';
    }

    public function place($req,$res){
        $cart = $_SESSION['cart'] ?? [];
        if (!$cart) { $_SESSION['error'] = 'Your cart is empty.'; return $res->redirect('/shop'); }

        $lines = [];
        $subtotal = 0.0;
        foreach ($cart as $pid => $qty) {
            $p = \App\Models\Catalog::findProduct((int)$pid);
            if (!$p) continue;
            $price = \App\Models\Pricing::priceFor((int)$pid, (int)$qty);
            $line_total = $price * (int)$qty;
            $subtotal += $line_total;
            $lines[] = [
                'product_id' => (int)$pid,
                'sku' => $p['sku'],
                'name' => $p['name'],
                'qty' => (int)$qty,
                'uom' => $p['uom'] ?? 'ea',
                'price' => $price,
                'discount' => 0,
                'tax' => 0,
            ];
        }

        $data = [
            'user_id' => \App\Core\Auth::user()['id'] ?? null,
            'type' => 'retail',
            'subtotal' => $subtotal,
            'discount_total' => 0,
            'tax_total' => 0,
            'shipping_total' => 0,
            'grand_total' => $subtotal,
            'currency' => 'USD',
            'po_number' => null,
        ];

        $order_id = \App\Models\OrderModel::createOrder($data, $lines);
        unset($_SESSION['cart']);
        $_SESSION['flash'] = 'Order placed: #' . $order_id;
        return $res->redirect('/account');
    }
}
