<?php
namespace App\Models;
use App\Core\DB;

class Category {
    public static function all(){
        return DB::$pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll();
    }
    public static function find($id){
        $st = DB::$pdo->prepare("SELECT * FROM categories WHERE id=?");
        $st->execute([$id]); return $st->fetch();
    }
    public static function create($name, $slug){
        $st = DB::$pdo->prepare("INSERT INTO categories (name, slug, created_at, updated_at) VALUES (?,?,NOW(),NOW())");
        $st->execute([$name, $slug]);
    }
    public static function update($id, $name, $slug){
        $st = DB::$pdo->prepare("UPDATE categories SET name=?, slug=?, updated_at=NOW() WHERE id=?");
        $st->execute([$name, $slug, $id]);
    }
    public static function delete($id){
        $st = DB::$pdo->prepare("DELETE FROM categories WHERE id=?");
        $st->execute([$id]);
    }
}
