<?php $title='Order Detail'; ob_start(); ?>
<h1>Order <?= htmlspecialchars($order['order_number']) ?></h1>

<div class="card">
  <div class="grid grid-2">
    <div>
      <strong>Status:</strong> <?= htmlspecialchars($order['status']) ?><br>
      <strong>Type:</strong> <?= htmlspecialchars($order['type']) ?><br>
      <strong>Currency:</strong> <?= htmlspecialchars($order['currency']) ?><br>
      <strong>Placed:</strong> <?= htmlspecialchars($order['placed_at']) ?><br>
      <strong>QB Txn ID:</strong> <?= htmlspecialchars($order['qb_txn_id'] ?? '—') ?><br>
      <strong>Sync:</strong> <?= htmlspecialchars($order['sync_status'] ?? 'pending') ?><br>
      <?php if(!empty($order['sync_error'])): ?>
        <div class="alert bad">Sync Error: <?= nl2br(htmlspecialchars($order['sync_error'])) ?></div>
      <?php endif; ?>
    </div>
    <div>
      <strong>Totals</strong><br>
      Subtotal: $<?= number_format((float)$order['subtotal'],2) ?><br>
      Discount: $<?= number_format((float)$order['discount_total'],2) ?><br>
      Tax: $<?= number_format((float)$order['tax_total'],2) ?><br>
      Shipping: $<?= number_format((float)$order['shipping_total'],2) ?><br>
      <strong>Grand Total: $<?= number_format((float)$order['grand_total'],2) ?></strong><br>
    </div>
  </div>
</div>

<h2>Items</h2>
<table class="table">
  <tr><th>SKU</th><th>Name</th><th>Qty</th><th>Price</th><th>Line Total</th></tr>
  <?php foreach($order['items'] as $it): ?>
  <tr>
    <td><?= htmlspecialchars($it['sku']) ?></td>
    <td><?= htmlspecialchars($it['name']) ?></td>
    <td><?= (int)$it['qty'] ?></td>
    <td>$<?= number_format((float)$it['price'],2) ?></td>
    <td>$<?= number_format((float)$it['line_total'],2) ?></td>
  </tr>
  <?php endforeach; ?>
</table>

<form class="card" method="post" action="<?= app_url('admin/orders/status') ?>">
  <input type="hidden" name="id" value="<?= (int)$order['id'] ?>">
  <label>Update Status</label>
  <select name="status">
    <?php foreach(['draft','pending','paid','fulfilled','cancelled'] as $s): ?>
      <option value="<?= $s ?>" <?= $order['status']===$s?'selected':'' ?>><?= $s ?></option>
    <?php endforeach; ?>
  </select>
  <div class="actions">
    <button class="btn btn-primary">Save</button>
    <a class="btn" href="<?= app_url('admin/orders') ?>">Back</a>
  </div>
</form>

<?php $content=ob_get_clean(); include __DIR__ . '/../../layouts/base.php'; ?>
