<?php $title='Your Cart'; ob_start(); ?>
<h1>Your Cart</h1>
<form method="post" action="<?= app_url('cart/update') ?>">
<table class="table" style="width:100%;border-collapse:collapse">
  <tr><th>SKU</th><th>Name</th><th>Qty</th><th>Price</th><th>Subtotal</th></tr>
  <?php $subtotal=0; foreach($lines as $l): $subtotal+=$l['subtotal']; ?>
  <tr>
    <td><?= htmlspecialchars($l['sku']) ?></td>
    <td><?= htmlspecialchars($l['name']) ?></td>
    <td><input type="number" name="qty[<?= (int)$l['product_id'] ?>]" value="<?= (int)$l['qty'] ?>" min="1"></td>
    <td>$<?= number_format((float)$l['price'],2) ?></td>
    <td>$<?= number_format((float)$l['subtotal'],2) ?></td>
  </tr>
  <?php endforeach; ?>
</table>
<p><strong>Subtotal:</strong> $<?= number_format((float)$subtotal,2) ?></p>
<div>
  <button class="btn">Update Cart</button>
  <a class="btn" href="<?= app_url('cart/clear') ?>">Clear</a>
  <a class="btn btn-primary" href="<?= app_url('checkout') ?>">Checkout</a>
</div>
</form>
<?php $content=ob_get_clean(); include __DIR__ . '/../layouts/base.php'; ?>
