<?php
namespace App\Controllers;
use App\Models\Catalog;
use App\Models\Pricing;

class ShopController {
    public function __construct(private array $config){}

    public function index(){
        $products = Catalog::listProducts();
        include __DIR__ . '/../Views/shop/index.php';
    }

    public function addToCart($req,$res){
        $pid = (int)($_POST['product_id'] ?? 0);
        $qty = max(1, (int)($_POST['qty'] ?? 1));
        if ($pid <= 0) { return $res->redirect('/shop'); }
        $price = \App\Models\Pricing::priceFor($pid, $qty);
        if (!isset($_SESSION['cart'])) $_SESSION['cart'] = [];
        $_SESSION['cart'][$pid] = ($_SESSION['cart'][$pid] ?? 0) + $qty;
        $_SESSION['flash'] = 'Added to cart';
        return $res->redirect('/cart');
    }
}
