<?php
namespace App\Models;
use App\Core\DB;

class Product {
    public static function all(){
        return DB::$pdo->query("SELECT * FROM products ORDER BY name")->fetchAll();
    }
    public static function find($id){
        $st = DB::$pdo->prepare("SELECT * FROM products WHERE id=?");
        $st->execute([$id]); return $st->fetch();
    }
    public static function create($data){
        $st = DB::$pdo->prepare("INSERT INTO products (sku,name,description,uom,base_price,tax_class,barcode,weight,status,created_at,updated_at) VALUES (?,?,?,?,?,?,?,?,?,NOW(),NOW())");
        $st->execute([
            $data['sku'],$data['name'],$data['description'] ?? null,$data['uom'] ?? 'ea',
            $data['base_price'] ?? 0,$data['tax_class'] ?? null,$data['barcode'] ?? null,
            $data['weight'] ?? null,$data['status'] ?? 'active'
        ]);
        return DB::$pdo->lastInsertId();
    }
    public static function update($id,$data){
        $st = DB::$pdo->prepare("UPDATE products SET sku=?, name=?, description=?, uom=?, base_price=?, tax_class=?, barcode=?, weight=?, status=?, updated_at=NOW() WHERE id=?");
        $st->execute([
            $data['sku'],$data['name'],$data['description'] ?? null,$data['uom'] ?? 'ea',
            $data['base_price'] ?? 0,$data['tax_class'] ?? null,$data['barcode'] ?? null,
            $data['weight'] ?? null,$data['status'] ?? 'active',$id
        ]);
    }
    public static function delete($id){
        $st = DB::$pdo->prepare("DELETE FROM products WHERE id=?");
        $st->execute([$id]);
    }
}
