<?php
namespace App\Models;
use App\Core\DB;

class PriceList {
    public static function all(){
        return DB::$pdo->query("SELECT * FROM price_lists ORDER BY name")->fetchAll();
    }
    public static function find($id){
        $st = DB::$pdo->prepare("SELECT * FROM price_lists WHERE id=?");
        $st->execute([$id]); return $st->fetch();
    }
    public static function create($name,$currency,$is_default){
        if ($is_default) { DB::$pdo->exec("UPDATE price_lists SET is_default=0"); }
        $st = DB::$pdo->prepare("INSERT INTO price_lists (name,currency,is_default,created_at,updated_at) VALUES (?,?,?,NOW(),NOW())");
        $st->execute([$name,$currency,$is_default?1:0]);
        return DB::$pdo->lastInsertId();
    }
    public static function update($id,$name,$currency,$is_default){
        if ($is_default) { DB::$pdo->exec("UPDATE price_lists SET is_default=0"); }
        $st = DB::$pdo->prepare("UPDATE price_lists SET name=?, currency=?, is_default=?, updated_at=NOW() WHERE id=?");
        $st->execute([$name,$currency,$is_default?1:0,$id]);
    }
    public static function delete($id){
        $st = DB::$pdo->prepare("DELETE FROM price_lists WHERE id=?");
        $st->execute([$id]);
    }
}

class PriceListItem {
    public static function forList($price_list_id){
        $st = DB::$pdo->prepare("SELECT pli.*, p.sku, p.name FROM price_list_items pli JOIN products p ON p.id=pli.product_id WHERE price_list_id=? ORDER BY p.name");
        $st->execute([$price_list_id]); return $st->fetchAll();
    }
    public static function upsert($price_list_id,$product_id,$price,$min_qty){
        $st = DB::$pdo->prepare("INSERT INTO price_list_items (price_list_id,product_id,price,min_qty) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE price=VALUES(price), min_qty=VALUES(min_qty)");
        $st->execute([$price_list_id,$product_id,$price,$min_qty]);
    }
    public static function delete($id){
        $st = DB::$pdo->prepare("DELETE FROM price_list_items WHERE id=?");
        $st->execute([$id]);
    }
}
